﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="index1.aspx.cs" Inherits="index1" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" />

    <!-- Bootstrap CSS -->
    <link href="favicon.png" rel="icon">
    <link href="https://fonts.googleapis.com/css?family=Muli:200,300,400,500,600,700,800,900|Oswald:200,300,400,500,600,700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <link href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
    <link href="assets/css/FMCGstyle.css" rel="stylesheet">
	<link href="assets/css/responsive.css" rel="stylesheet">
    <title>CII NATIONAL FMCG SUMMIT</title>
</head>
<body>
    <form id="form1" runat="server">
    <header class="header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-3 col-sm-3 col-12 lb text-center">
                    <a href="index.aspx" class="logo_box">
                        <img src="assets/images/logo.png" alt="logo" class="img-fluid">
                    </a>
                </div>
                <div class="col-md-7 col-sm-7 col-12"> 
					<ul class="menu">
						<li><a href="index.aspx" class="nav_actv">Home</a></li>
						<li><a href="#speakers">Speakers</a></li>
						<li><a href="#agenda">Agenda</a></li>
						<li><a href="#sponsor">Partners</a></li>
						<li><a href="retrospective.html">Retrospective</a></li>
						<li><a href="gallery.html">Photo Gallery</a></li>
						<li><a href="#contact">Contact</a></li>
						<li><a href="about.html">About</a></li>
					</ul>
                </div>
                <div class="col-md-2 col-sm-2 col-12 mm">
					<div class="c_text_right">
				    	<a href="registration.aspx" class="register">Register Now</a>
				    	<span class="mobile_menu">
							<img src="assets/images/menu.svg" alt="mobile menu" class="img-fluid">
						</span>
						<div class="mobile_mnu_bx">
							<ul>
								<li><a href="index.aspx" class="nav_actv">Home</a></li>
								<li><a href="#speakers">Speakers</a></li>
								<li><a href="#agenda">Agenda</a></li>
								<li><a href="#sponsor">Partners</a></li>
								<li><a href="retrospective.html">Retrospective</a></li>
								<li><a href="gallery.html">Photo Gallery</a></li>
								<li><a href="#contact">Contact</a></li>
								<li><a href="about.html">About</a></li>
							</ul>
						</div>
				    </div>
               		
                </div>
            </div>
        </div>
    </header>
        <div class="banner_section">
            <div class="taj">
                <img src="assets/images/taj-new.png" alt="" class="img-fluid">
            </div>
            <div class="p1" data-speed="0.01" data-revert="true" style="background-image: url(assets/images/products/bg.png)"></div>
            <div class="p2" data-speed="0.02" style="background-image: url(assets/images/prdcts.png)"></div>
            <div class="groth">
                <img src="assets/images/growth-new.png" alt="" class="img-fluid">
            </div>
        </div>
        <div class="about_section section_space" id="about">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-md-6 col-sm-6 col-12 pad_left_nill">
                        <div class="about_img">
                            <img src="assets/images/about-1.png" alt="" class="img-fluid">
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-6 col-12">
                        <h1 class="title_tag_1"><span>ABOUT</span><br>
                            The Summit</h1>
                        <p class="nrml_txt">
                            What a year 2020 has been - the outbreak in Q1, widespread lockdown in Q2, phased reopening in Q3 and finally, the promise of a vaccine in Q4 and beyond. <br><br>
                            COVID has changed the way we consume. More consumers are buying categories online today, than ever before. For instance, first-time buyers comprised 40% of India online staples shoppers and 30% of online personal care shoppers in 2020, with 50% of them planning to continue buying online post the crisis1. While some consumption patterns may to revert to earlier ways post the crisis, many are likely to remain beyond 2020. COVID has also changed the way we work. Coming into 2020, Indian FMCG companies were already dealing with slowing consumption and were undertaking initiatives to reignite growth. The pandemic resulted in supply chain disruption and manpower shortage at an unprecedented scale and pace. It also accelerated digital technology adoption by 5-10 years, as forced social distancing massively increased remote working in 2020. This has forced FMCG companies to retool their ways of working to rapidly adapt to the changing environment. <br><br>To enable business leaders and marketing practitioners develop innovative solutions to these critical challenges, the <strong>Confederation of Indian Industry</strong> is organizing the <strong>National FMCG Summit</strong> on <strong>16 - 17 October, 2020</strong>. Driven by the immense support received from the Industry and stakeholders, the Summit has established itself as the apex forum for policy advocacy and perspective sharing for the FMCG Sector. This year, the Summit will be held virtually on the <strong>CII HIVE platform</strong> to highlight a dramatically evolving business scenario and how the FMCG Industry has been forced to reinvent business strategies and adapt to this unprecedented crisis
    					<!--<br>
                            <br>
                            In order to enable business leaders overcome the enormous challenges being faced by the FMCG Sector due to a protracted consumption slowdown and weakening consumer sentiment, the Confederation of Indian Industry is organizing the National FMCG Summit on December 18, 2019 at the Taj Lands End, Mumbai. <span class="more_txt">The Summit will feature the very best of Indian FMCG leaders who have made great progress over the past decade towards becoming “scale insurgents” and Insurgency is critical to the way brands are establishing themselves and scaling up. The Summit will also feature leaders who have built and rejuvenated enduring brands with purpose that resonate with millions of consumers across economic and social strata. Participants will hear the perspectives on the emergence of a full stack retailer who can identify pockets of need, create and serve demand meaningfully by being in close contact with the consumer. Serving billions of consumers day after day has led to a heavy impact on nature. The challenge for business leaders is to grow rapidly yet sustainably and how they can drive sustainability as a core value across every single consumer interaction, every day.</span>
                            <br>
                            <br>
                            <a href="#!" id="more_txt" class="rd_mr">Read more</a>-->
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="spkrs_sec section_space" id="speakers">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 col-sm-12 col-12">
                        <h2 class="title_tag_1 text-center"><span>2020</span><br>
                            Speakers</h2>
                        <ul class="spkr_list">
                        
                        <li>
                            <a href="javascript:void(0);" class="total_spkr_bx" data-toggle="modal" data-target="#BharatPuri">
                                <div class="spkr_bx">
                                    <img src="assets/images/speaker/Bharat-Puri.jpg" alt="bharat puri" class="img-fluid">
                                    <div class="spkr_desc">
                                        <div class="shrt">
                                            <h4>Bharat Puri</h4>
                                            <p>Chairman, CII National Committee on FMCG and Managing Director, Pidilite Industries</p>
                                        </div>
                                    </div>
                                </div>                          
                            <h4 class="sprk_name">Bharat Puri</h4>
                            </a>
                        </li>
                        <div id="BharatPuri" class="modal fade" role="dialog">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                <h4 class="spkr_name">Bharat Puri</h4>
                                <p class="spkr_dsg">Chairman, CII National Committee on FMCG and Managing Director, Pidilite Industries</p>
                              </div>
                              <div class="modal-body">
                                <p class="modal_txt">
                                    <img src="assets/images/speaker/Bharat-Puri.jpg" alt="bharat puri" class="img-fluid">
                                    Bharat Puri is currently the Managing Director of Pidilite Industries Ltd, having joined the Board of Pidilite Industries Ltd as an Independent Director in 2008 and being appointed Managing Director in April 2015.Pidilite is India’s leading manufacturer of consumer adhesives, sealants, construction chemicals, art and craft products as well as polymer emulsions.Over the past few years, Pidilite has emerged as one of India’s most respected consumer companies.
                                    <br><br>
                                    Bharat was at school at the Lawrence School Sanawar, graduated in Commerce from Punjab University and completed his Post Graduate Diploma in Management (MBA) from the Indian Institute of Management, Ahmedabad.
                                    <br><br>
Starting his career with Asian Paints in 1982, he rose to eventually heading Sales and Marketing for the company. He moved to Cadbury India as Director of Sales and Marketing in 1998, and was appointed its Managing Director in 2002. In 2006, he was posted to Singapore in a Regional role. He then held senior leadership positions in Sales, Marketing and General Management, at the regional, and global level, culminating in his becoming Global President, Chocolates, Gum and Candy, for Mondelez International. Bharat has been a successful global business leader who has built, energised and led diverse teams across numerous geographies in both developed and developing markets.
<br><br>
As a person, Bharat can be described as open, curious, fair with a strong bias for action and a strong belief in the power of teams.
                                </p>
                              </div>
                            </div>
                          </div>
                        </div>
                        <li>
                            <a href="javascript:void(0);" class="total_spkr_bx">
                                <div class="spkr_bx">
                                    <img src="assets/images/speaker/Damodar-Mall.jpg" alt="Damodar-Mall" class="img-fluid">
                                    <div class="spkr_desc">
                                        <div class="shrt">
                                            <h4>Damodar Mall</h4>
                                            <p>&nbsp;</p>
                                        </div>
                                    </div>
                                </div>                          
                            <h4 class="sprk_name">Damodar Mall</h4>
                            </a>
                        </li>

                        <li>
                            <a href="javascript:void(0);" class="total_spkr_bx" data-toggle="modal" data-target="#DeepakIyer">
                                <div class="spkr_bx">
                                    <img src="assets/images/speaker/Deepak-Iyer.jpg" alt="Deepak Iyer" class="img-fluid">
                                    <div class="spkr_desc">
                                        <div class="shrt">
                                            <h4>Deepak Iyer</h4>
                                            <p>President Mondelez India Foods Pvt. Ltd.</p>
                                        </div>
                                    </div>
                                </div>                          
                            <h4 class="sprk_name">Deepak Iyer</h4>
                            </a>
                        </li>
                        <div id="DeepakIyer" class="modal fade" role="dialog">
                          <div class="modal-dialog">
                            <div class="modal-content">
                              <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                <h4 class="spkr_name">Deepak Iyer</h4>
                                <p class="spkr_dsg">President Mondelez India Foods Pvt. Ltd.</p>
                              </div>
                              <div class="modal-body">
                                <p class="modal_txt">
                                    <img src="assets/images/speaker/Deepak-Iyer.jpg" alt="Deepak Iyer" class="img-fluid">
                                    Deepak Iyer is President of Mondelez India Foods Pvt. Ltd and is responsible for leading the business of Mondelēz International in this dynamic and emerging market. Deepak is also part of the Asia Pacific, Middle East and Africa (AMEA) Leadership Team.
<br><br>
With close to twenty-five years of management experience spanning sales, marketing, franchise management and general management, Deepak has extensive experience in the FMCG space.
<br><br>
Prior to joining Mondelez India, he was the CEO and Managing Director of Bharti AXA General Insurance Company Ltd.<br><br>He has also served as CEO and Managing Director, Indian Subcontinent at Wrigley India Pvt. Ltd,<br><br>Deepak was earlier with PepsiCo Inc. for 17 years working in different roles in India, South Asia and Africa. He has also worked in Marico Industries, Coats Viyella India and Tata Telecom Ltd.<br><br>He holds a Master of Management Studies (MBA), Marketing from SP Jain Institute, Mumbai and a Bachelor of Engineering, Electronics from Sardar Patel University, Gujarat.
                                </p>
                              </div>
                            </div>
                          </div>
                        </div>
                        <li>
                            <a href="javascript:void(0);" class="total_spkr_bx">
                                <div class="spkr_bx">
                                    <img src="assets/images/speaker/Sameer-Satpathy.jpg" alt="Sameer-Satpathy" class="img-fluid">
                                    <div class="spkr_desc">
                                        <div class="shrt">
                                            <h4>Sameer Satpathy</h4>
                                            <p>&nbsp;</p>
                                        </div>
                                    </div>
                                </div>                          
                            <h4 class="sprk_name">Sameer Satpathy</h4>
                            </a>
                        </li>
                        <li>
                            <a href="javascript:void(0);" class="total_spkr_bx">
                                <div class="spkr_bx">
                                    <img src="assets/images/speaker/Varun-Berry.jpg" alt="Varun-Berry" class="img-fluid">
                                    <div class="spkr_desc">
                                        <div class="shrt">
                                            <h4>Varun Berry</h4>
                                            <p>&nbsp;</p>
                                        </div>
                                    </div>
                                </div>                          
                            <h4 class="sprk_name">Varun Berry</h4>
                            </a>
                        </li>
                        <li>
                            <a href="javascript:void(0);" class="total_spkr_bx">
                                <div class="spkr_bx">
                                    <img src="assets/images/speaker/Abheek-Singhi.jpg" alt="Abheek-Singhi" class="img-fluid">
                                    <div class="spkr_desc">
                                        <div class="shrt">
                                            <h4>Abheek Singhi</h4>
                                            <p>&nbsp;</p>
                                        </div>
                                    </div>
                                </div>                          
                            <h4 class="sprk_name">Abheek Singhi</h4>
                            </a>
                        </li>


                        
                        
                    </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="key_objectives section_space">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 col-sm-12 col-12 text-center">
                        <h2 class="title_tag_1 whte"><span>key</span><br>
                            Objectives</h2>
                        <p class="nrml_txt">
                            To highlight the unprecedented developments amidst the COVID pandemic, emerging consumption patterns and policy dimensions  while identifying the major growth enablers which will help drive and transform the FMCG landscape in the future<br>
                            	<span class="bullets"></span>
                            <br>
                            To be held as a signature and impact generating initiative that will showcase emerging trends and new dimensions in the FMCG sector
                            <br>
                            	<span class="bullets"></span>
                            <br>
                            Highlight long term transformative marketing trends in the context of changes in consumer centric technologies and behavior
                            <br>
                            	<span class="bullets"></span>
                            <br>
                            Showcase contemporary approaches to overcome the challenges posed by disruptive competition and emerging technologies
                            <br>
                            	<span class="bullets"></span>
                            <br>
                            Deliberate upon robust business plans based on state of the art research and findings
                        </p>
                    </div>

                </div>
            </div>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-md-12 col-sm-12 col-12">
                    <ul class="count">
                        <li>
                            <div class="counter_div">
                                <p>
                                    <span class="milestone timer1">500</span><span>+</span><br>
                                    PARTICIPANTS
                                </p>
                            </div>
                        </li>
                        <li>
                            <div class="counter_div">
                                <p>
                                    <span class="milestone timer2">6</span><span></span><br>
                                    SESSIONS
                                </p>
                            </div>
                        </li>
                        <li>
                            <div class="counter_div">
                                <p>
                                    <span class="milestone timer3">30</span><span>+</span><br>
                                    SPEAKERS
                                </p>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 col-sm-12 col-12">
                    <div class="initiatives">
                        <h3>Components of The Initiative</h3>
                        <ul>
                            <li>
                                <div class="display_table">
                                    <img src="assets/images/keynote.png" alt="keynote">
                                    <p>Keynote Presentations & Panel Discussions</p>
                                </div>
                            </li>
                            <li>
                                <div class="display_table">
                                    <img src="assets/images/prespective.png" alt="prespective">
                                    <p>Perspective Sharing by Domain Experts, Industry & Thought Leaders</p>
                                </div>
                            </li>
                            <li>
                                <div class="display_table">
                                    <img src="assets/images/research.png" alt="research">
                                    <p>Research & Case Study Presentations</p>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="sumit_agenda section_space" id="agenda">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 col-sm-12 col-12">
                        <h1 class="title_tag_1 grey text-center"><span>summit</span><br>
                            Agenda</h1>
                    </div>
                    <div class="col-md-12 col-sm-12 col-12">
                        <div class="tab_bx">
                            <ul class="new_agenda_tab">
                                <li class="tab-link current" data-tab="Day_1">Day 1 <span>9<sup>th</sup> December 2020</span></li>
                                <li class="tab-link" data-tab="Day_2">Day 2 <span>10<sup>th</sup> December 2020</span></li>
                            </ul>

                            <!-- tab content start -->
                            <div class="tab-content current" id="Day_1">
                               <div id="accordion" class="new_agenda_accordion">
                                  <div class="card">
                                    <div class="card-header" id="headingFirst">
                                      <h5 class="mb-0">
                                        <a class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseFirst" aria-expanded="false" aria-controls="collapseFirst"><div class="row p-0">
                                          <div class="col-sm-2 col-12">1145 – 1205 Hrs.</div>
                                          <div class="col-sm-9 col-12">OPENING SESSION</div>
                                          <div class="col-sm-1 col-12 text-right"><i class="fa fa-angle-down" aria-hidden="true"></i></div>
                                        </div>
                                          
                                        </a>
                                      </h5>
                                    </div>
                                
                                    <div id="collapseFirst" class="collapse" aria-labelledby="headingFirst" data-parent="#accordion">
                                      <div class="card-body">
                                        <div class="table-responsive">
                                          <table class="table" cellpadding="0" cellspacing="0">
                                            <tbody>
                                              <tr>
                                                <td width="20%" style="border-top: none;">Opening Remarks</td>
                                                <td width="80%" style="border-top: none;">
                                                  <strong>Ms. Indrani Kar</strong><br>Principal Advisor <br>Confederation of Indian Industry
                                                </td>
                                              </tr> 
                                              <tr>
                                                <td width="20%">Welcome Address & Introduction to the Summit</td>
                                                <td width="80%">
                                                  <strong>Mr. Bharat Puri</strong><br>Chairman, CII National Committee on FMCG and <br>Managing Director, Pidilite Industries
                                                </td>
                                              </tr>                             
                                            </tbody>
                                          </table>
                                        </div>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="card">
                                    <div class="card-header" id="headingSecond">
                                      <h5 class="mb-0">
                                        <a class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseSecond" aria-expanded="false" aria-controls="collapseSecond"><div class="row p-0">
                                          <div class="col-sm-2 col-12">1205 – 1210 Hrs.</div>
                                          <div class="col-sm-10 col-12">Session Changeover</div>
                                        </div>
                                          
                                        </a>
                                      </h5>
                                    </div>
                                  </div>

                                  <div class="card">
                                    <div class="card-header" id="headingThird">
                                      <h5 class="mb-0">
                                        <a class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseThird" aria-expanded="false" aria-controls="collapseThird"><div class="row p-0">
                                          <div class="col-sm-2 col-12">1210– 1310 Hrs.</div>
                                          <div class="col-sm-9 col-12">Session-I: 2020 Megatrends & Implications for FMCG</div>
                                          <div class="col-sm-1 col-12 text-right"><i class="fa fa-angle-down" aria-hidden="true"></i></div>
                                        </div>
                                          
                                        </a>
                                      </h5>
                                    </div>
                                
                                    <div id="collapseThird" class="collapse" aria-labelledby="headingThird" data-parent="#accordion">
                                      <div class="card-body">
                                        <p class="nrml_txt">
                                          History shows us that changes after a crisis are not always temporary - crises
can fundamentally reshape our beliefs and behaviours. How then can FMCG
companies prepare for a post-COVID world, rather than hunkering down and
waiting for a return to the past?

                                        </p>
                                        <p class="nrml_txt">
                                          BCG global and Indian experts will do a jugalbandi to share a perspective on
the lasting shifts in social attitudes, policy, work, and consumption likely to
emerge from the COVID-19 pandemic, both globally and in India. This session
aims to be deliberately provocative and expansive, with the objective of spurring
us to think non-linearly about the road ahead for FMCG in India. This will be
followed by a leadership panel to distil out key implications for Indian FMCG
companies in the new normal.
                                        </p>
                                        <div class="table-responsive">
                                          <table class="table" cellpadding="0" cellspacing="0">
                                            <tbody>
                                              <tr>
                                                <td width="20%" style="border-top: none;"><strong><u>Moderator:</u></strong></td>
                                                <td width="80%" style="border-top: none;">
                                                  <strong>Mr. Abheek Singhi</strong><br>Managing Director and Senior Partner <br>Asia-Pacific Leader, Consumer and Retail Practice<br> Boston Consulting Group, Mumbai
                                                </td>
                                              </tr> 
                                              <tr>
                                                <td width="20%"><strong><u>Theme Presentation :</u></strong></td>
                                                <td width="80%">
                                                  <strong>Mr. Martin Reeves</strong><br>Chairman BCG Henderson Institute<br><br>
                                                  <strong>LEADERSHIP PANEL DISCUSSION</strong>
                                                </td>
                                              </tr> 
                                              <tr>
                                                <td width="20%"><strong><u>Speakers :</u></strong></td>
                                                <td width="80%">
                                                  <strong>Mr. Bharat Pur</strong><br>Chairman, CII National Committee on FMCG and Managing Director, Pidilite Industries <br><br>
                                                  <strong>Mr. Varun Berry</strong><br>Managing Director Britannia Industries
                                                </td>
                                              </tr>  
                                                                   
                                            </tbody>
                                          </table>
                                        </div>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="card">
                                    <div class="card-header" id="headingFour">
                                      <h5 class="mb-0">
                                        <a class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour"><div class="row p-0">
                                          <div class="col-sm-2 col-12">1310 – 1315 Hrs</div>
                                          <div class="col-sm-10 col-12">Session Changeover</div>
                                        </div>
                                          
                                        </a>
                                      </h5>
                                    </div>
                                  </div>

                                  <div class="card">
                                    <div class="card-header" id="headingFive">
                                      <h5 class="mb-0">
                                        <a class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive"><div class="row p-0">
                                          <div class="col-sm-2 col-12">1315 – 1415 Hrs.</div>
                                          <div class="col-sm-9 col-12">Session-II: Fireside Chat - "Winning in the Crisis"</div>
                                          <div class="col-sm-1 col-12 text-right"><i class="fa fa-angle-down" aria-hidden="true"></i></div>
                                        </div>
                                          
                                        </a>
                                      </h5>
                                    </div>
                                
                                    <div id="collapseFive" class="collapse" aria-labelledby="headingFive" data-parent="#accordion">
                                      <div class="card-body">
                                        <p class="nrml_txt">How did winning global FMCG companies navigate the COVID crisis? The CEO
of a leading global FMCG will share his perspective on what happened in the
crisis, and how different companies, including his, responded to the external
and internal challenges they faced to win in 2020.</p>
                                        <div class="table-responsive">
                                          <table class="table" cellpadding="0" cellspacing="0">
                                            <tbody>
                                              <tr>
                                                <td width="20%" style="border-top: none;"><strong><u>Speakers:</u></strong></td>
                                                <td width="80%" style="border-top: none;">
                                                  <strong>Mr. Laxman Narasimhan </strong><br>Global CEO  <br>Reckitt Benckiser <br><br>
                                                  <strong>Mr. Bharat Puri </strong><br>Chairman, CII National Committee on FMCG and  <br>Managing Director Pidilite Industries
                                                </td>
                                              </tr>  
                                                                   
                                            </tbody>
                                          </table>
                                        </div>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="card">
                                    <div class="card-header" id="headingSix">
                                      <h5 class="mb-0">
                                        <a class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix"><div class="row p-0">
                                          <div class="col-sm-2 col-12">1415 – 1445 Hrs</div>
                                          <div class="col-sm-10 col-12">Lunch Break</div>
                                        </div>
                                          
                                        </a>
                                      </h5>
                                    </div>
                                  </div>

                                  <div class="card">
                                    <div class="card-header" id="headingSeven">
                                      <h5 class="mb-0">
                                        <a class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven"><div class="row p-0">
                                          <div class="col-sm-2 col-12">1445 – 1545 Hrs</div>
                                          <div class="col-sm-9 col-12">SESSION-III: Building & Sustaining Brands in and Post COVID</div>
                                          <div class="col-sm-1 col-12 text-right"><i class="fa fa-angle-down" aria-hidden="true"></i></div>
                                        </div>
                                          
                                        </a>
                                      </h5>
                                    </div>
                                
                                    <div id="collapseSeven" class="collapse" aria-labelledby="headingSeven" data-parent="#accordion">
                                      <div class="card-body">
                                        <p class="nrml_txt">During COVID, consumers migrated to brands they believed will serve best
their requirements of safety, quality, nutrition, convenience and value. The
market also witnessed a flurry of accelerated innovation and new product
launches in 2020 to meet different consumer demand brought on by the crisis.
Many FMCG companies with strong brands used this opportunity to further
strengthen their positions in 2020, and some expanded into new spaces
leveraging their brands. These last few months have also seen the rise of new
brands and resurgence of some old brands</p>
<p class="nrml_txt">In this session, leaders who have nurtured some of India’s most loved and
trusted brands will share their learnings and lessons from 2020, and what the
road ahead for building and sustaining brands in the post COVID India looks
like – when consumer trust is more important than ever before.</p>
                                        <div class="table-responsive">
                                          <table class="table" cellpadding="0" cellspacing="0">
                                            <tbody>
                                              <tr>
                                                <td width="20%" style="border-top: none;"><strong><u>Moderator:</u></strong></td>
                                                <td width="80%" style="border-top: none;">
                                                  <strong>Mr. Prabha Narasimhan </strong><br>Executive Director Hindustan Unilever Ltd 
                                                </td>
                                              </tr>  
                                              <tr>
                                                <td width="20%"><strong><u>Speakers:</u></strong></td>
                                                <td width="80%">
                                                  <strong>Mr. Sameer Satpathy </strong><br>Chief Executive -Personal Care ITC Ltd<br><br>
                                                  <strong>Mr. Varun Alagh </strong><br>Co-Founder & CEO Mamaearth<br><br>
                                                  <strong>Mr. Anil Viswanathan </strong><br>Director – Marketing (Chocolates) Mondelez India Foods
                                                </td>
                                              </tr> 
                                                                   
                                            </tbody>
                                          </table>
                                        </div>
                                      </div>
                                    </div>
                                  </div>

                              </div>
                            </div>
                            <!-- tab content end -->

                            <!-- tab content start -->
                            <div class="tab-content" id="Day_2">
                                <div id="day_2_accordion" class="new_agenda_accordion">
                                  <div class="card">
                                    <div class="card-header" id="headingFirst">
                                      <h5 class="mb-0">
                                        <a class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapse_day_2_First" aria-expanded="false" aria-controls="collapse_day_2_First"><div class="row p-0">
                                          <div class="col-sm-2 col-12">1400– 1500 Hrs.</div>
                                          <div class="col-sm-9 col-12">Session-IV: Next Gen FMCG Sales & Distribution</div>
                                          <div class="col-sm-1 col-12 text-right"><i class="fa fa-angle-down" aria-hidden="true"></i></div>
                                        </div>
                                          
                                        </a>
                                      </h5>
                                    </div>
                                
                                    <div id="collapse_day_2_First" class="collapse" aria-labelledby="heading_day_2_First" data-parent="#day_2_accordion">
                                      <div class="card-body">
                                        <p class="nrml_txt">The disruption of distribution during COVID was one of the biggest challenges
faced by FMCG companies this year. While consumer demand was largely
intact at an overall level, there were shifts in consumer shopping patterns across
channels with online in particular witnessing significant growth in 2020. The
kirana store at one end and the e-commerce at the other end of the spectrum
emerged stronger during the crisis due to both supply and demand side factors.
New distribution ecosystems are emerging to cater to the Kirana revival, while
Direct-to-Consumer models are gaining salience in parallel.</p>
<p class="nrml_txt">In this session, leaders from different elements of retail value chain share their
perspectives on how to navigate this new normal.</p>
                                        <div class="table-responsive">
                                          <table class="table" cellpadding="0" cellspacing="0">
                                            <tbody>
                                              <tr>
                                                <td width="20%" style="border-top: none;"><strong><u>Moderator:</u></strong></td>
                                                <td width="80%" style="border-top: none;">
                                                  <strong>Mr. Kalpesh Parmar</strong><br>General Manager Mars Wrigley India
                                                </td>
                                              </tr> 
                                              <tr>
                                                <td width="20%"><strong><u>Speakers:</u></strong></td>
                                                <td width="80%">
                                                  <strong>Mr. Sunil Kataria</strong><br>CEO - India & SAARC Godrej Consumer Products<br><br>
                                                  <strong>Mr. Damodar Mall</strong><br>Chief Executive Officer, Grocery Retail Reliance Retail<br><br>
                                                  <strong>Mr. Ashish Jhina</strong><br>Co-Founder & COO
Jumbotail
                                                </td>
                                              </tr>                             
                                            </tbody>
                                          </table>
                                        </div>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="card">
                                    <div class="card-header" id="heading_day_2_Second">
                                      <h5 class="mb-0">
                                        <a class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapse_day_2_Second" aria-expanded="false" aria-controls="collapse_day_2_Second"><div class="row p-0">
                                          <div class="col-sm-2 col-12">1500 – 1515 Hrs.</div>
                                          <div class="col-sm-10 col-12">Session Changeover</div>
                                        </div>
                                          
                                        </a>
                                      </h5>
                                    </div>
                                  </div>

                                  <div class="card">
                                    <div class="card-header" id="heading_day_2_Third">
                                      <h5 class="mb-0">
                                        <a class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapse_day_2_Third" aria-expanded="false" aria-controls="collapse_day_2_Third"><div class="row p-0">
                                          <div class="col-sm-2 col-12">1515 – 1615 Hrs.</div>
                                          <div class="col-sm-9 col-12">Session-V: Rural Growth Engine for FMCG</div>
                                          <div class="col-sm-1 col-12 text-right"><i class="fa fa-angle-down" aria-hidden="true"></i></div>
                                        </div>
                                          
                                        </a>
                                      </h5>
                                    </div>
                                
                                    <div id="collapse_day_2_Third" class="collapse" aria-labelledby="heading_day_2_Third" data-parent="#day_2_accordion">
                                      <div class="card-body">
                                        <p class="nrml_txt">
                                          FMCG demand in rural India remained robust in 2020, driven by higher farm
incomes, lesser pandemic incidence, minimal disruption due to lockdown and
reverse migration. The slowdown in the urban areas also nudged companies to
explore rural with greater focus than most times before. Subsequently, in Q2,
FMCG in rural areas grew three times of the all India numbers in June2. Rural
was earlier characterised with lower income, focus on agriculture, having poor
physical reach and lower media reach. Over the last few years, this gap has
reduced on a secular basis – and at a faster basis so rural has become more
important and more complex for companies to participate and win in. Winning
in rural India goes beyond just physical reach, and in this session, experts on
rural India share their perspective on the latest developments in rural India and
what it takes to succeed in (more than) half of India

                                        </p>
                                        <div class="table-responsive">
                                          <table class="table" cellpadding="0" cellspacing="0">
                                            <tbody>
                                              <tr>
                                                <td width="20%" style="border-top: none;"><strong><u>Moderator:</u></strong></td>
                                                <td width="80%" style="border-top: none;">
                                                  <strong>Mr. Namit Puri</strong><br>Managing Director & Partner
Consumer and Retail Practice
Boston Consulting Group, Mumbai

                                                </td>
                                              </tr> 
                                              <tr>
                                                <td width="20%"><strong><u>Speakers :</u></strong></td>
                                                <td width="80%">
                                                  <strong>Mr. Sridhar Gundaiah</strong><br>Founder & CEO Store King<br><br>
                                                  <strong>Mr. Sanjay Gupta</strong><br>Country Manager and Vice President (Sales and Operations) Google India<br><br>
                                                  <strong>Mr. Salil Dalal</strong><br>Chief Operating Officer - Emerging India Division
Pidilite Industries
                                                </td>
                                              </tr> 
                                                                                                                 
                                            </tbody>
                                          </table>
                                        </div>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="card">
                                    <div class="card-header" id="heading_day_2_Four">
                                      <h5 class="mb-0">
                                        <a class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapse_day_2_Four" aria-expanded="false" aria-controls="collapse_day_2_Four"><div class="row p-0">
                                          <div class="col-sm-2 col-12">1615 – 1630 Hrs.</div>
                                          <div class="col-sm-10 col-12">Session Changeover</div>
                                        </div>
                                          
                                        </a>
                                      </h5>
                                    </div>
                                  </div>

                                  <div class="card">
                                    <div class="card-header" id="heading_day_2_Five">
                                      <h5 class="mb-0">
                                        <a class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapse_day_2_Five" aria-expanded="false" aria-controls="collapse_day_2_Five"><div class="row p-0">
                                          <div class="col-sm-2 col-12">1630 – 1730 Hrs.</div>
                                          <div class="col-sm-9 col-12">SESSION-VI: Winning the Digital Consumer</div>
                                          <div class="col-sm-1 col-12 text-right"><i class="fa fa-angle-down" aria-hidden="true"></i></div>
                                        </div>
                                          
                                        </a>
                                      </h5>
                                    </div>
                                
                                    <div id="collapse_day_2_Five" class="collapse" aria-labelledby="heading_day_2_Five" data-parent="#day_2_accordion">
                                      <div class="card-body">
                                        <p class="nrml_txt">COVID has accelerated us 5-10 years into our digital future. Consumers are
spending more time on digital media in 2020 than in previous years. While there
is no debate that digital is becoming increasingly important to engage with
consumers, the key questions are how to effectively make it happen. .</p>
<p class="nrml_txt">In this session, FMCG digital marketers share their lessons on direct to
consumer digital marketing and the importance of taking an end-to-end view in
adapting the way they reach consumers in an increasingly digital world.</p>
                                        <div class="table-responsive">
                                          <table class="table" cellpadding="0" cellspacing="0">
                                            <tbody>
                                              <tr>
                                                <td width="20%" style="border-top: none;"><strong><u>Moderator:</u></strong></td>
                                                <td width="80%" style="border-top: none;">
                                                  <strong>Mr. Ram Raghavan </strong><br>Managing Director Colgate-Palmolive (India)
                                                </td>
                                              </tr>  
                                              <tr>
                                                <td width="20%"><strong><u>Speakers:</u></strong></td>
                                                <td width="80%">
                                                  <strong>Mr. Sandeep Bhushan </strong><br>Director and Head of India GMS Facebook<br><br>
                                                  <strong>Mr. Nikhil Chand </strong><br>Director, Foods and Confectionery Nestle India<br><br>
                                                  <strong>Mr. Amit Jain </strong><br>Managing Director LO'real India
                                                </td>
                                              </tr>
                                                                   
                                            </tbody>
                                          </table>
                                        </div>
                                      </div>
                                    </div>
                                  </div>

                                  <div class="card">
                                    <div class="card-header" id="heading_day_2_Six">
                                      <h5 class="mb-0">
                                        <a class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapse_day_2_Six" aria-expanded="false" aria-controls="collapse_day_2_Six"><div class="row p-0">
                                          <div class="col-sm-2 col-12">1730 – 1740 Hrs.</div>
                                          <div class="col-sm-9 col-12">Vote of Thanks</div>
                                          <div class="col-sm-1 col-12 text-right"><i class="fa fa-angle-down" aria-hidden="true"></i></div>
                                        </div>
                                          
                                        </a>
                                      </h5>
                                    </div>
                                
                                    <div id="collapse_day_2_Six" class="collapse" aria-labelledby="heading_day_2_Six" data-parent="#day_2_accordion">
                                      <div class="card-body">
                                        <div class="table-responsive">
                                          <table class="table" cellpadding="0" cellspacing="0">
                                            <tbody>
                                              <tr>
                                                <td width="20%" style="border-top: none;">&nbsp;</td>
                                                <td width="80%" style="border-top: none;">
                                                  <strong>Mr. Deepak Iyer </strong><br>Co-CII National Committee on FMCG & Managing Director,
Mondelez India Foods
                                                </td>
                                              </tr>  
                                                                   
                                            </tbody>
                                          </table>
                                        </div>
                                      </div>
                                    </div>
                                  </div>

                              </div>
                            </div>
                            <!-- tab content end -->

                        </div>
                    </div>

                </div>
            </div>
        </div>


        <div class="sponsor text-center" id="sponsor">
            <h2 class="title_tag_1 pnk"><span>2019</span><br>Partners</h2>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12 col-sm-12 col-12 section_space">
                    <h3 class="sponsor_hdr">Premium Partner</h3>
                    <ul class="sponsor_list">
                        <li><a href="http://www.pidilite.com/" target="_blank"><img src="assets/images/sponsors/pidilite.jpg" class="img-100" alt="pidilite"></a></li>
                    </ul>
                    <h3 class="sponsor_hdr mt-4">Diamond Partners</h3>
                    <ul class="sponsor_list">
                    	<li><a href="https://www.godrejcp.com/" target="_blank"><img src="assets/images/sponsors/godrej.jpg" class="img-100" alt="godrej"></a></li>
                        <li><a href="https://www.hul.co.in/" target="_blank"><img src="assets/images/sponsors/hul.jpg" class="img-100" alt="hul"></a></li>
                        <li><a href="https://in.mondelezinternational.com/home" target="_blank"><img src="assets/images/sponsors/mondetez.jpg" class="img-100" alt="mondetez"></a></li>
                        <li><a href="https://www.rb.com/" target="_blank"><img src="assets/images/sponsors/rb.jpg" class="img-100" alt="rb"></a></li>
                        <li><a href="https://www.tatachemicals.com/" target="_blank"><img src="assets/images/sponsors/tata-salt.jpg" class="img-100" alt="tata-salt"></a></li>
                        <li><a href="http://www.tataglobalbeverages.com/?reload" target="_blank"><img src="assets/images/sponsors/tata-tea-gold.jpg" class="img-100" alt="tata-tea-gold"></a></li>
                    </ul>
                    <h3 class="sponsor_hdr mt-4">Platinum Partners</h3>
                    <ul class="sponsor_list">
                        <li><a href="https://www.colgatepalmolive.co.in/" target="_blank"><img src="assets/images/sponsors/colgate.jpg" class="img-100" alt="colgate"></a></li>
                        <li><a href="http://www.emamiltd.in/" target="_blank"><img src="assets/images/sponsors/emami.jpg" class="img-100" alt="Emami"></a></li>
                        <li><a href="https://www.itcportal.com/brands-microsite/sunfeast.aspx" target="_blank"><img src="assets/images/sponsors/sunfeast.jpg" class="img-100" alt="sunfeast"></a></li>
                        <li><a href="https://www.jnj.in/" target="_blank"><img src="assets/images/sponsors/jhonson.jpg" class="img-100" alt="Johnson & Johnson"></a></li>
                        <li><a href="https://www.kelloggs.in/en_IN/home.html" target="_blank"><img src="assets/images/sponsors/kellogs.jpg" class="img-100" alt="Kellogg’s"></a></li>
                        <li><a href="https://www.lotusherbals.com/" target="_blank"><img src="assets/images/sponsors/lotus.jpg" class="img-100" alt="Lotus Herbal"></a></li>
                        <li><a href="https://www.motherdairy.com/" target="_blank"><img src="assets/images/sponsors/mother-dairy.jpg" class="img-100" alt="Mother Diary"></a></li>
                        <li><a href="https://www.nestle.in/" target="_blank"><img src="assets/images/sponsors/nestle.jpg" class="img-100" alt="Nestle"></a></li>
                        <li><a href="https://www.nielsen.com/in/en/" target="_blank"><img src="assets/images/sponsors/neilsen.jpg" class="img-100" alt="Nielsen"></a></li>
                        <li><a href="https://wcclg.com/" target="_blank"><img src="assets/images/sponsors/santoor.jpg" class="img-100" alt="Santoor"></a></li>
                    </ul>
                    <h3 class="sponsor_hdr mt-4">Gold Partners</h3>
                    <ul class="sponsor_list">
                    	<li><a href="https://www.adaniwilmar.com/" target="_blank"><img src="assets/images/sponsors/adani.jpg" class="img-100" alt="adani"></a></li>
                        <li><a href="https://www.asianpaints.com/" target="_blank"><img src="assets/images/sponsors/asian-paints.jpg" class="img-100" alt="Asian Paints"></a></li>
                        <li><a href="http://britannia.co.in/" target="_blank"><img src="assets/images/sponsors/britinia.jpg" class="img-100" alt="Britania"></a></li>
                        <li><a href="http://www.perfettivanmelle.in/" target="_blank"><img src="assets/images/sponsors/perfetti.jpg" class="img-100" alt="Perfetti"></a></li>
                    </ul>
                    <h3 class="sponsor_hdr mt-4">Silver Partners</h3>
                    <ul class="sponsor_list">
                    	<li><a href="http://www.dsgroup.com/" target="_blank"><img src="assets/images/sponsors/DS-Logo.jpg" class="img-100" alt="DS Logo"></a></li>
                        <li><a href="https://drvaidyas.com/" target="_blank"><img src="assets/images/sponsors/dr-vaidya.jpg" class="img-100" alt="Dr. Vaidya"></a></li>
                        <li><a href="https://himalayawellness.in/" target="_blank"><img src="assets/images/sponsors/himalaya.jpg" class="img-100" alt="Himalaya"></a></li>
                        <li><a href="https://recykal.com/" target="_blank"><img src="assets/images/sponsors/recykal.jpg" class="img-100" alt="recykal"></a></li>
                    </ul>
                    <h3 class="sponsor_hdr mt-4">Corporate Contributor</h3>
                    <ul class="sponsor_list">
                        <li><a href="https://www.sugarlite.com/" target="_blank"><img src="assets/images/sponsors/sugarlite.jpg" class="img-100" alt="sugarlite"></a></li>                       
                    </ul>
                    <h3 class="sponsor_hdr mt-4">Knowledge Partner</h3>
                    <ul class="sponsor_list">
                        <li><a href="https://www.bain.com/" target="_blank"><img src="assets/images/sponsors/bain-co.jpg" class="img-100" alt="Bain"></a></li>                       
                    </ul>

                    <!-- <img src="assets/images/sponsors-2019.png" alt="" class="img-fluid"> -->
                </div>
            </div>
        </div>
        <div class="map">
            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3771.4590658939396!2d72.81726711483024!3d19.043543557940712!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3be7c945f2fb1149%3A0xa2ba742a39963b31!2sTaj%20Lands%20End%2C%20Mumbai!5e0!3m2!1sen!2sin!4v1575453365522!5m2!1sen!2sin" width="100%" height="350" frameborder="0" style="border: 0;" allowfullscreen=""></iframe>
        </div>

        <footer id="contact">
    	<div class="form_bx section_space">
            <div class="container">
                <div class="row">
                    <div class="col-md-5 col-sm-5 col-12 mtxtcent">
                        <h2 class="title_tag_1 blue"><span>quick</span><br>Inquiry</h2>
                        <p class="con_txt">For any inquiry fill this form & <br> submit. We will get back to you<br> as soon as possible.</p>
                    </div>
                    <div class="col-md-7 col-sm-7 col-12">
                        <div class="form-group">
                            <asp:TextBox ID="txtName" runat="server" CssClass="input_contact" placeholder="Name"></asp:TextBox>
                        </div>
                        <div class="form-group">
                            <asp:TextBox ID="txtEmail" runat="server" CssClass="input_contact" placeholder="Email"></asp:TextBox>
                        </div>
                        <div class="form-group">
                            <asp:TextBox ID="txtMessage" runat="server" CssClass="input_contact" placeholder="Message" TextMode="MultiLine" Rows="3"></asp:TextBox>
                        </div>
                        <div class="text-center">
                            <asp:Button ID="btnSubmit" runat="server" Text="Submit" CssClass="submit_btn" OnClick="btnSubmit_Click"></asp:Button>
                            
                        </div>
                        <div  class="text-center">
                            <asp:Label ID="lblMsg" runat="server" style="color: #fff; margin: 20px 0 0 0; display: inline-block;"></asp:Label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
       <div class="ftr"> 
           <div class="container">
                <div class="row justify-content-center align-items-center">
                    <div class="col-md-6 col-sm-6 col-12">
                        <div class="contact_person">
                            <h5>Rajib Roy |  Director</h5>
                            <h6>Confederation of Indian Industry</h6>
                            <ul>
                                <li><img src="assets/images/phone.png" alt="phone"><a href="tel:09007512777">09007512777</a></li>
                                <li><img src="assets/images/email.png" alt="phone"><a href="mailto:rajib.roy@cii.in">rajib.roy@cii.in</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-6 col-12">
                        <p class="footer_txt">© ciifmcgsummit 2019, All rights reserved<br>
                            <a href="http://www.globopex.com/" target="_blank">Made in Globopex</a></p>
                    </div>
                </div>
            </div>
        </div>
    </footer>
        <a href="javascript:" id="return-to-top"><i class="fa fa-angle-up" aria-hidden="true"></i></a>
        <!-- Optional JavaScript -->
        <!-- jQuery first, then Popper.js, then Bootstrap JS -->
        <script src="https://code.jquery.com/jquery-2.2.4.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
        <script src="assets/js/custom.js"></script>
        <script type="text/javascript">
            $(".new_agenda_tab li").click(function() {
                var e = $(this).attr("data-tab");
                $(".new_agenda_tab li").removeClass("current");
                $(".tab-content").removeClass("current");
                $(this).addClass("current");
                $("#" + e).addClass("current");
            });
        </script>
    </form>
</body>
</html>
