﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="feedback.aspx.cs" Inherits="app_feedback" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,minimum-scale=1,initial-scale=1,user-scalable=no">
    <!-- Bootstrap CSS -->
    <link href="https://fonts.googleapis.com/css?family=Nunito+Sans:400,600,700,800,900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/mobile-style.css">
    <title>CII NATIONAL FMCG SUMMIT</title>
</head>
<body>
    <form id="form1" runat="server">
        <asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>
        <div class="banner_section">
            <img src="assets/images/banner.jpg" alt="banner" class="img-fluid">
        </div>
        <div class="main_wrapper">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="feedback_form">
                            <h4 class="primary_hdr">Give your feedback</h4>
                            <p>Thank you for participating in CII National FMCG Summit 2019. We would appreciate if you could kindly give us your valuable feedback.</p>
                            <div class="form-group">
                                <asp:Label ID="lblQues1" runat="server" Text="1.  What is your overall evaluation of the conference?" Font-Bold="true"></asp:Label>
                                <br />
                                <asp:RadioButtonList ID="rdoAns1" runat="server">
                                    <asp:ListItem>More than Satisfactory</asp:ListItem>
                                    <asp:ListItem>Satisfactory</asp:ListItem>
                                    <asp:ListItem>Less than Satisfactory</asp:ListItem>
                                </asp:RadioButtonList>
                            </div>

                            <div class="form-group">
                                <asp:Label ID="lblQues2" runat="server" Text="2. What is your rating of the overall effectiveness of the presentations and speakers you heard?" Font-Bold="true"></asp:Label>
                                <br />
                                <asp:RadioButtonList ID="rdoAns2" runat="server">
                                    <asp:ListItem>More than Satisfactory</asp:ListItem>
                                    <asp:ListItem>Satisfactory</asp:ListItem>
                                    <asp:ListItem>Less than Satisfactory</asp:ListItem>
                                </asp:RadioButtonList>
                            </div>

                            <div class="form-group">
                                <asp:Label ID="lblQues3" runat="server" Text="3. What aspects of the conference were of most value to you?" Font-Bold="true"></asp:Label>
                                <asp:TextBox ID="txtAns3" runat="server" TextMode="MultiLine" Rows="2" placeholder="Your Answer" CssClass="input_100" MaxLength="500"></asp:TextBox>
                            </div>

                            <div class="form-group">
                                <asp:Label ID="lblQues4" runat="server" Text="4.  What aspects of the conference were of least value to you?" Font-Bold="true"></asp:Label>
                                <asp:TextBox ID="txtAns4" runat="server" TextMode="MultiLine" Rows="2" placeholder="Your Answer" CssClass="input_100" MaxLength="500"></asp:TextBox>
                            </div>

                            <div class="form-group">
                                <asp:Label ID="lblQues5" runat="server" Text="5.  Please list suggestions for topics and speakers for future regional conferences. We are interested in the issues you are facing or the presentations you would find most valuable." Font-Bold="true"></asp:Label>
                                <asp:TextBox ID="txtAns5" runat="server" TextMode="MultiLine" Rows="2" placeholder="Your Answer" CssClass="input_100" MaxLength="500"></asp:TextBox>
                            </div>

                            <div class="form-group">
                                <asp:Label ID="lblQues6" runat="server" Text="6.  How did you first learn about this conference?" Font-Bold="true"></asp:Label><br />
                                <asp:RadioButtonList ID="rdoAns6" runat="server" OnSelectedIndexChanged="rdoAns6_SelectedIndexChanged" AutoPostBack="true">
                                    <asp:ListItem>Website</asp:ListItem>
                                    <asp:ListItem>Email or e-newsletter</asp:ListItem>
                                    <asp:ListItem>Advertisement in Newspaper</asp:ListItem>
                                    <asp:ListItem>Social Media</asp:ListItem>
                                    <asp:ListItem>Other</asp:ListItem>
                                </asp:RadioButtonList>
                                <asp:TextBox ID="txtAns6_Other" runat="server" placeholder="Please Specify" CssClass="input_100 w-50" Enabled="false" MaxLength="500"></asp:TextBox><br />
                            </div>
                            <h4 class="primary_hdr">Contact Details of the Participant</h4>
                            <div class="form-group">
                                <asp:TextBox ID="txtName" runat="server" placeholder="Name" CssClass="input_100"></asp:TextBox>
                            </div>
                            <div class="form-group">
                                <asp:TextBox ID="txtDesignation" runat="server" placeholder="Designation" CssClass="input_100"></asp:TextBox>
                            </div>
                            <div class="form-group">
                                <asp:TextBox ID="txtOrganisation" runat="server" placeholder="Organisation" CssClass="input_100"></asp:TextBox>
                            </div>
                            <div class="form-group">
                                <asp:TextBox ID="txtMobile" runat="server" placeholder="Mobile No." CssClass="input_100" MaxLength="10"></asp:TextBox>
                                <ajaxToolkit:FilteredTextBoxExtender ID="ftetxtMobile" runat="server"   FilterType="Numbers"  TargetControlID="txtMobile" />
                            </div>
                            <div class="form-group">
                                <asp:TextBox ID="txtEmail" runat="server" placeholder="Email ID" CssClass="input_100"></asp:TextBox>
                                <ajaxToolkit:FilteredTextBoxExtender ID="ftetxtEmail" runat="server" FilterMode="ValidChars"  FilterType="Custom, LowercaseLetters,UppercaseLetters" ValidChars=".@_-" TargetControlID="txtEmail" />
                            </div>
                            <div class="text-center">
                                <asp:Button ID="btnSubmit" runat="server" Text="Submit" CssClass="submit_btn" OnClick="btnSubmit_Click" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <footer class="footer">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12 pad_nill">
                        <ul class="footer_menu">
                            <li>
                                <a href="index.html">
                                    <img src="assets/images/home.svg" alt="">
                                    <span>Home</span>
                                </a>
                            </li>
                            <li>
                                <a href="agenda.html">
                                    <img src="assets/images/calender.svg" alt="">
                                    <span>Agenda</span>
                                </a>
                            </li>
                            <li>
                                <a href="speakers.html">
                                    <img src="assets/images/microphone.svg" alt="">
                                    <span>Speakers</span>
                                </a>
                            </li>
                            <li>
                                <a href="sponsor.html">
                                    <img src="assets/images/sponsors.svg" alt="">
                                    <span>Partners</span>
                                </a>
                            </li>
                            <li>
                                <a href="feedback.aspx" class="nav_active">
                                    <img src="assets/images/feedback.svg" alt="">
                                    <span>Feedback</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <p class="footer_txt">© cii-hrconclave2019 | Made by <a href="http://www.globopex.com/" target="_blank">Globopex</a></p>
        </footer>
        <!-- Optional JavaScript -->
        <!-- jQuery first, then Popper.js, then Bootstrap JS -->
        <script src="https://code.jquery.com/jquery-1.12.4.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
    </form>
</body>
</html>
